---
--- Author: raptor
---

---
-- Round a number to a certain number of decimal places
-- idp = number of decimal places
function round(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult + 0.5) / mult
end


-- Start tests
local p = point.new(100, 200)
assert(p.x == 100)
assert(p.y == 200)

print 'new() OK'


local dot = point.dot(point.new(10, 7), point.new(2, 5))
assert(dot == 10 * 2 + 7 * 5)

print 'dot() OK'


local cross = point.cross(point.new(10, 7), point.new(2, 5))
assert(cross.x == 10 * 5 - 7 * 2)
assert(cross.y == 0)  -- Hard coded?

print 'cross() OK'


local length = point.length(point.new(11, 60))
assert(length == 61)

print 'length() OK'


local lengthSquared = point.lengthSquared(point.new(5, 12))
assert(lengthSquared == 13 * 13)

print 'lengthSquared() OK'


local normalize = point.normalize(point.new(3, 4))
assert(round(normalize.x, 6) == 0.6)
assert(round(normalize.y, 6) == 0.8)

print 'normalize() OK'


local angleTo = point.angleTo(point.new(0,0), point.new(1,1))
assert(round((math.pi / 4), 6) == round(angleTo, 6))

print 'angleTo() OK'


local distanceTo = point.distanceTo(point.new(1,1), point.new(6, 13))
assert(distanceTo == 13)

print 'distanceTo() OK'


local distSquared = point.distSquared(point.new(-1,-1), point.new(4, 11))
assert(distSquared == 169)

print 'distSquared() OK'
